/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AnimatedAttributeListener;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import java.util.LinkedList;
import org.w3c.dom.Element;

public abstract class AbstractSVGAnimatedValue
implements AnimatedLiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean hasAnimVal;
    protected LinkedList<AnimatedAttributeListener> listeners = new LinkedList();

    public AbstractSVGAnimatedValue(AbstractElement abstractElement, String string, String string2) {
        this.element = abstractElement;
        this.namespaceURI = string;
        this.localName = string2;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isSpecified() {
        return this.hasAnimVal || this.element.hasAttributeNS(this.namespaceURI, this.localName);
    }

    protected abstract void updateAnimatedValue(AnimatableValue var1);

    @Override
    public void addAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        if (!this.listeners.contains(animatedAttributeListener)) {
            this.listeners.add(animatedAttributeListener);
        }
    }

    @Override
    public void removeAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        this.listeners.remove(animatedAttributeListener);
    }

    protected void fireBaseAttributeListeners() {
        if (this.element instanceof SVGOMElement) {
            ((SVGOMElement)this.element).fireBaseAttributeListeners(this.namespaceURI, this.localName);
        }
    }

    protected void fireAnimatedAttributeListeners() {
        for (AnimatedAttributeListener animatedAttributeListener : this.listeners) {
            animatedAttributeListener.animatedAttributeChanged((Element)((Object)this.element), this);
        }
    }
}

