/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractSVGLength;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.DefaultLengthHandler;
import io.sf.carte.echosvg.parser.LengthListHandler;
import io.sf.carte.echosvg.parser.LengthListParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public abstract class AbstractSVGLengthList
extends AbstractSVGList
implements SVGLengthList {
    protected short direction;
    public static final String SVG_LENGTH_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_LENGTH_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGLengthList(short s) {
        this.direction = s;
    }

    public SVGLength initialize(SVGLength sVGLength) throws DOMException, SVGException {
        return (SVGLength)this.initializeImpl(sVGLength);
    }

    public SVGLength getItem(int n) throws DOMException {
        return (SVGLength)this.getItemImpl(n);
    }

    public SVGLength insertItemBefore(SVGLength sVGLength, int n) throws DOMException, SVGException {
        return (SVGLength)this.insertItemBeforeImpl(sVGLength, n);
    }

    public SVGLength replaceItem(SVGLength sVGLength, int n) throws DOMException, SVGException {
        return (SVGLength)this.replaceItemImpl(sVGLength, n);
    }

    public SVGLength removeItem(int n) throws DOMException {
        return (SVGLength)this.removeItemImpl(n);
    }

    public SVGLength appendItem(SVGLength sVGLength) throws DOMException, SVGException {
        return (SVGLength)this.appendItemImpl(sVGLength);
    }

    protected SVGItem createSVGItem(Object object) {
        SVGLength sVGLength = (SVGLength)object;
        return new SVGLengthItem(sVGLength.getCSSUnitType(), sVGLength.getValueInSpecifiedUnits(), this.direction);
    }

    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        LengthListBuilder lengthListBuilder = new LengthListBuilder(listHandler);
        LengthListParser lengthListParser = new LengthListParser((LengthListHandler)lengthListBuilder);
        lengthListParser.parse(string);
    }

    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGLength)) {
            this.createSVGException((short)0, "expected.length", null);
        }
    }

    public void copyTo(AbstractSVGList abstractSVGList) {
        super.copyTo(abstractSVGList);
        AbstractSVGLengthList abstractSVGLengthList = (AbstractSVGLengthList)abstractSVGList;
        abstractSVGLengthList.direction = this.direction;
    }

    protected class LengthListBuilder
    extends DefaultLengthHandler
    implements LengthListHandler {
        protected ListHandler listHandler;
        protected float currentValue;
        protected short currentType;

        public LengthListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startLengthList() throws ParseException {
            this.listHandler.startList();
        }

        public void startLength() throws ParseException {
            this.currentType = 0;
            this.currentValue = 0.0f;
        }

        public void lengthValue(float f) throws ParseException {
            this.currentValue = f;
        }

        protected void setUnit(short s) {
            this.currentType = s;
        }

        public void endLength() throws ParseException {
            this.listHandler.item((SVGItem)new SVGLengthItem(this.currentType, this.currentValue, AbstractSVGLengthList.this.direction));
        }

        public void endLengthList() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGLengthItem
    extends AbstractSVGLength
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGLengthItem(short s, float f, short s2) {
            super(s2);
            this.unitType = s;
            this.value = f;
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)((Object)AbstractSVGLengthList.this.getElement());
        }

        public void setParent(AbstractSVGList abstractSVGList) {
            this.parentList = abstractSVGList;
        }

        public AbstractSVGList getParent() {
            return this.parentList;
        }

        @Override
        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

