/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.bsfv.BSimFeatureVisualizerPlugin;
import ghidra.bsfv.BsfvRowObject;
import ghidra.bsfv.BsfvTableModel;
import ghidra.bsfv.BsfvTokenHighlightMatcher;
import ghidra.bsfv.ClearDecompilerHighlightsAction;
import ghidra.bsfv.HighlightAndGraphAction;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class BsfvTableProvider
extends ComponentProviderAdapter {
    private BSimFeatureVisualizerPlugin plugin;
    private JComponent component;
    private GhidraTable bsimFeatureTable;
    private GhidraThreadedTablePanel<BsfvRowObject> bsimFeatureTablePanel;
    private BsfvTableModel model;
    private GhidraTableFilterPanel<BsfvRowObject> tableFilterPanel;
    private JPanel panel;
    private Component table;
    private ClearDecompilerHighlightsAction clearingAction;

    public BsfvTableProvider(BSimFeatureVisualizerPlugin plugin) {
        super(plugin.getTool(), "BSimFeatureVisualizer", plugin.getName());
        this.plugin = plugin;
        this.component = this.build();
        this.setTransient();
        this.tool.addComponentProvider((ComponentProvider)this, true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        HighlightAndGraphAction highlightAndGraphAction = new HighlightAndGraphAction(this, plugin);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)highlightAndGraphAction);
        this.clearingAction = new ClearDecompilerHighlightsAction(plugin);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.clearingAction);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void reload() {
        if (this.isVisible()) {
            this.clearingAction.clearHighlights();
            this.model.reload(this.plugin.getCurrentProgram());
            this.setTitle(this.getTitleText());
        }
    }

    public void programOpened(Program program) {
        if (this.isVisible()) {
            this.model.reload(program);
            this.setTitle(this.getTitleText());
        }
    }

    public void programDeactivated() {
        this.clearingAction.clearHighlights();
        this.model.reload(null);
        this.setTitle(this.getTitleText());
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
    }

    public void componentShown() {
        this.model.reload(this.plugin.getCurrentProgram());
    }

    public void componentHidden() {
        this.clearingAction.clearHighlights();
    }

    GhidraTable getTable() {
        return this.bsimFeatureTable;
    }

    BsfvTableModel getModel() {
        return this.model;
    }

    private String getTitleText() {
        String title = "BSim Feature Visualizer";
        if (this.plugin.getCurrentProgram() == null) {
            return title;
        }
        ProgramLocation loc = this.plugin.getProgramLocation();
        if (loc == null) {
            return title;
        }
        Function func = this.plugin.getCurrentProgram().getFunctionManager().getFunctionContaining(loc.getAddress());
        if (func == null) {
            return title;
        }
        return title + ": " + func.getName();
    }

    private JComponent build() {
        this.panel = new JPanel(new BorderLayout());
        this.table = this.buildTablePanel();
        this.panel.add(this.table, "Center");
        return this.panel;
    }

    private Component buildTablePanel() {
        this.model = new BsfvTableModel(this.plugin, this.plugin.getCurrentProgram());
        this.bsimFeatureTablePanel = new GhidraThreadedTablePanel((ThreadedTableModel)this.model, 1000);
        this.bsimFeatureTable = this.bsimFeatureTablePanel.getTable();
        this.bsimFeatureTable.setName("BSim Features");
        this.bsimFeatureTable.installNavigation((ServiceProvider)this.tool);
        this.bsimFeatureTable.setNavigateOnSelectionEnabled(true);
        this.bsimFeatureTable.setAutoResizeMode(2);
        this.bsimFeatureTable.setPreferredScrollableViewportSize(new Dimension(900, 300));
        this.bsimFeatureTable.setRowSelectionAllowed(true);
        this.bsimFeatureTable.setSelectionMode(0);
        this.bsimFeatureTable.getSelectionModel().addListSelectionListener(e -> {
            if (!this.plugin.getHighlightByRow()) {
                return;
            }
            DecompilerHighlightService service = this.plugin.getDecompilerHighlightService();
            if (service == null) {
                return;
            }
            int selectedRow = this.bsimFeatureTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            BsfvRowObject row = (BsfvRowObject)this.model.getRowObject(selectedRow);
            BsfvTokenHighlightMatcher tokenMatcher = new BsfvTokenHighlightMatcher(row, this.model.getHighFunction(), this.plugin);
            DecompilerHighlighter highlighter = service.createHighlighter("BSimFeatureHighlighter", (CTokenHighlightMatcher)tokenMatcher);
            highlighter.applyHighlights();
        });
        this.model.addTableModelListener(e -> {
            int rowCount = this.model.getRowCount();
            int unfilteredCount = this.model.getUnfilteredRowCount();
            StringBuilder buffy = new StringBuilder();
            buffy.append(rowCount).append(" items");
            if (rowCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(" )");
            }
            this.setSubTitle(buffy.toString());
        });
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)this.bsimFeatureTable, (RowObjectTableModel)this.model);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this.bsimFeatureTablePanel, "Center");
        container.add((Component)this.tableFilterPanel, "South");
        return container;
    }
}

