/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class ResponseOptionalValues
extends QueryResponseRecord {
    public Object[] resultArray = null;
    public boolean tableExists = true;

    public ResponseOptionalValues() {
        super("responseoptionalvalues");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        if (!this.tableExists) {
            fwrite.append("<exists>false</exists>\n");
        }
        if (this.resultArray != null) {
            for (Object value : this.resultArray) {
                fwrite.append("<val>");
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)value.toString());
                fwrite.append("</val>\n");
            }
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.tableExists = true;
        this.resultArray = null;
        ArrayList<String> resValues = new ArrayList<String>();
        parser.start(new String[]{this.name});
        if (parser.peek().getName().equals("exists")) {
            parser.start(new String[]{"exists"});
            this.tableExists = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        while (parser.peek().isStart()) {
            parser.start(new String[0]);
            String value = parser.end().getText();
            resValues.add(value);
        }
        parser.end();
        if (!resValues.isEmpty()) {
            this.resultArray = new Object[resValues.size()];
            resValues.toArray(this.resultArray);
        }
    }
}

