/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import java.util.HashMap;
import java.util.Map;

public enum SourceFileIdType {
    NONE(0, 0),
    UNKNOWN(1, 0),
    TIMESTAMP_64(2, 8),
    MD5(3, 16),
    SHA1(4, 20),
    SHA256(5, 32),
    SHA512(6, 64);

    public static final int MAX_LENGTH = 64;
    private static Map<Byte, SourceFileIdType> valueToEnum;
    private final int byteLength;
    private final byte index;

    private SourceFileIdType(byte index, int length) {
        this.byteLength = length;
        this.index = index;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    byte getIndex() {
        return this.index;
    }

    static SourceFileIdType getTypeFromIndex(byte index) {
        return valueToEnum.get(index);
    }

    static {
        valueToEnum = new HashMap<Byte, SourceFileIdType>();
        for (SourceFileIdType type : SourceFileIdType.values()) {
            valueToEnum.put(type.getIndex(), type);
        }
    }
}

