/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class HighExternalSymbol
extends HighSymbol {
    private Address resolveAddress;

    public HighExternalSymbol(String nm, Address addr, Address resolveAddr, PcodeDataTypeManager dtmanage) {
        super(0L, nm, DataType.DEFAULT, true, true, dtmanage);
        VariableStorage store;
        this.resolveAddress = resolveAddr;
        try {
            store = new VariableStorage((ProgramArchitecture)this.getProgram(), addr, 1);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_EXTERNREFSYMBOL);
        if (this.name != null && this.name.length() > 0) {
            encoder.writeString(AttributeId.ATTRIB_NAME, this.name + "_exref");
        }
        AddressXML.encode(encoder, this.resolveAddress);
        encoder.closeElement(ElementId.ELEM_EXTERNREFSYMBOL);
    }
}

