/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.util.SystemUtilities;

public class EquateOperandFieldLocation
extends OperandFieldLocation {
    private Equate equate;

    public EquateOperandFieldLocation(Program program, Address addr, Address refAddr, String rep, Equate equate, int opIndex, int subOpIndex, int charOffset) {
        super(program, addr, (VariableOffset)null, refAddr, rep, opIndex, subOpIndex, charOffset);
        if (equate == null) {
            throw new NullPointerException("Equate parameter cannot be null");
        }
        this.equate = equate;
    }

    public EquateOperandFieldLocation() {
    }

    public Equate getEquate() {
        return this.equate;
    }

    public long getEquateValue() {
        if (this.equate == null) {
            return Integer.MIN_VALUE;
        }
        return this.equate.getValue();
    }

    public EquateReference[] getReferences() {
        if (this.equate == null) {
            return new EquateReference[0];
        }
        return this.equate.getReferences();
    }

    @Override
    public String toString() {
        return super.toString() + ", Equate value = " + this.getEquateValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            EquateOperandFieldLocation loc = (EquateOperandFieldLocation)obj;
            return SystemUtilities.isEqual((Object)this.equate, (Object)loc.equate);
        }
        return false;
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        long value = obj.getLong("_EQUATE_VALUE", 0L);
        EquateTable equateTable = p.getEquateTable();
        this.equate = equateTable.getEquate(this.addr, this.getOperandIndex(), value);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putLong("_EQUATE_VALUE", this.getEquateValue());
    }
}

