/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.QUADRANT;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class MultiIconBuilder {
    private MultiIcon multiIcon;
    private String description;

    public MultiIconBuilder(Icon baseIcon) {
        this.multiIcon = new MultiIcon(Objects.requireNonNull(baseIcon));
    }

    public MultiIconBuilder addIcon(Icon icon, int w, int h, QUADRANT quandrant) {
        Icon scaled = ResourceManager.getScaledIcon(icon, w, h);
        int x = (this.multiIcon.getIconWidth() - scaled.getIconWidth()) * quandrant.x;
        int y = (this.multiIcon.getIconHeight() - scaled.getIconHeight()) * quandrant.y;
        TranslateIcon txIcon = new TranslateIcon(scaled, x, y);
        this.multiIcon.addIcon(txIcon);
        return this;
    }

    public MultiIconBuilder addIcon(Icon icon, int w, int h, int x, int y) {
        Icon scaled = ResourceManager.getScaledIcon(icon, w, h);
        TranslateIcon txIcon = new TranslateIcon(scaled, x, y);
        this.multiIcon.addIcon(txIcon);
        return this;
    }

    public MultiIconBuilder addLowerRightIcon(Icon icon) {
        return this.addIcon(icon, icon.getIconWidth(), icon.getIconHeight(), QUADRANT.LR);
    }

    public MultiIconBuilder addLowerRightIcon(Icon icon, int w, int h) {
        return this.addIcon(icon, w, h, QUADRANT.LR);
    }

    public MultiIconBuilder addLowerLeftIcon(Icon icon) {
        return this.addIcon(icon, icon.getIconWidth(), icon.getIconHeight(), QUADRANT.LL);
    }

    public MultiIconBuilder addLowerLeftIcon(Icon icon, int w, int h) {
        return this.addIcon(icon, w, h, QUADRANT.LL);
    }

    public MultiIconBuilder addCenteredIcon(Icon icon) {
        int x = (this.multiIcon.getIconWidth() - icon.getIconWidth()) / 2;
        int y = (this.multiIcon.getIconHeight() - icon.getIconHeight()) / 2;
        TranslateIcon txIcon = new TranslateIcon(icon, x, y);
        this.multiIcon.addIcon(txIcon);
        return this;
    }

    public MultiIconBuilder addText(String text, Font font, Color color, QUADRANT quandrant) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout tl = new TextLayout(text, font, frc);
        BufferedImage bi = new BufferedImage((int)Math.ceil(tl.getAdvance()), (int)Math.ceil(tl.getAscent() + tl.getDescent()), 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setFont(font);
        g2d.setColor(color);
        tl.draw(g2d, 0.0f, tl.getAscent());
        g2d.dispose();
        return this.addIcon(new ImageIcon(bi), bi.getWidth(), bi.getHeight(), quandrant);
    }

    public MultiIconBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ImageIcon build() {
        ImageIcon imageIcon = ResourceManager.getImageIcon(this.multiIcon);
        imageIcon.setDescription(this.getDescription());
        return imageIcon;
    }

    private String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.multiIcon.toString();
    }
}

