/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.microsoft.MicrosoftDemanglerOptions;
import ghidra.app.util.demangler.microsoft.MsCInterpretation;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;

public class MicrosoftMangledContext
extends MangledContext {
    public MicrosoftMangledContext(Program program, MicrosoftDemanglerOptions options, String mangled, Address address) {
        super(program, (DemanglerOptions)options, mangled, address);
    }

    public int getArchitectureSize() {
        if (this.program == null) {
            return 0;
        }
        return this.program.getAddressFactory().getDefaultAddressSpace().getSize();
    }

    boolean shouldInterpretAsFunction() {
        MsCInterpretation control = ((MicrosoftDemanglerOptions)this.options).getInterpretation();
        return switch (control) {
            case MsCInterpretation.FUNCTION -> true;
            case MsCInterpretation.NON_FUNCTION -> false;
            case MsCInterpretation.FUNCTION_IF_EXISTS -> {
                if (this.getExistingFunction() != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new AssertionError((Object)"Invalid case");
        };
    }

    private Function getExistingFunction() {
        if (this.program == null || this.address == null) {
            return null;
        }
        return this.program.getFunctionManager().getFunctionAt(this.address);
    }
}

