/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.app.util.task.OpenProgramRequest;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.feature.vt.api.util.VTSessionFileUtil;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.feature.vt.gui.wizard.session.SessionConfigurationPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class SessionConfigurationStep
extends WizardStep<NewSessionData> {
    private PluginTool tool;
    private SessionConfigurationPanel sessionPanel;

    protected SessionConfigurationStep(WizardModel<NewSessionData> model, PluginTool tool) {
        super(model, "New Version Tracking Session", new HelpLocation("VersionTrackingPlugin", "New_Session_Panel"));
        this.tool = tool;
        this.sessionPanel = new SessionConfigurationPanel(() -> this.notifyStatusChanged());
    }

    public void initialize(NewSessionData data) {
        this.sessionPanel.setSessionFolder(data.getSessionFolder());
        this.sessionPanel.setSourceFile(data.getSourceFile());
        this.sessionPanel.setDestinationFile(data.getDestinationFile());
    }

    public boolean isValid() {
        this.setStatusMessage("");
        DomainFolder sessionFolder = this.sessionPanel.getSessionFolder();
        String sessionName = this.sessionPanel.getSessionName();
        DomainFile sourceFile = this.sessionPanel.getSourceFile();
        DomainFile destinationFile = this.sessionPanel.getDestinationFile();
        return this.isValid(sessionFolder, sessionName, sourceFile, destinationFile);
    }

    public void populateData(NewSessionData data) {
        data.setSessionName(this.sessionPanel.getSessionName());
        data.setSessionFolder(this.sessionPanel.getSessionFolder());
        data.setSourceFile(this.sessionPanel.getSourceFile(), this.tool);
        data.setDestinationFile(this.sessionPanel.getDestinationFile(), this.tool);
    }

    public boolean canFinish(NewSessionData data) {
        return true;
    }

    protected void dispose(NewSessionData data) {
        this.releaseProgram(data.getSourceProgram());
        this.releaseProgram(data.getDestinationProgram());
    }

    private void releaseProgram(Program program) {
        if (program != null && program.getConsumerList().contains(this.tool)) {
            program.release((Object)this.tool);
        }
    }

    private boolean isValid(DomainFolder sessionFolder, String sessionName, DomainFile sourceFile, DomainFile destinationFile) {
        if (sessionFolder == null) {
            this.setStatusMessage("Choose a project folder to continue!");
            return false;
        }
        if (sourceFile == null) {
            this.setStatusMessage("Please choose a source program.");
            return false;
        }
        if (destinationFile == null) {
            this.setStatusMessage("Please choose a destination program.");
            return false;
        }
        if (sourceFile.equals((Object)destinationFile)) {
            this.setStatusMessage("Source and destination files must be different.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)sessionName)) {
            this.setStatusMessage("Please enter a name for this session");
            return false;
        }
        try {
            this.tool.getProject().getProjectData().testValidName(sessionName, false);
        }
        catch (InvalidNameException e) {
            this.setStatusMessage("'" + sessionName + "' contains invalid characters");
            return false;
        }
        DomainFile file = sessionFolder.getFile(sessionName);
        if (file != null) {
            this.setStatusMessage("'" + file.getPathname() + "' is the name of an existing project file");
            return false;
        }
        return true;
    }

    public boolean apply(NewSessionData data) {
        Program program;
        if (data.getSourceProgram() == null) {
            program = this.openSourceProgram(data.getSourceFile());
            if (program == null) {
                return false;
            }
            data.setSourceProgram(program);
        }
        if (data.getDestinationProgram() == null) {
            program = this.openDestinationProgram(data.getDestinationFile());
            if (program == null) {
                return false;
            }
            data.setDestinationProgram(program);
        }
        return true;
    }

    private Program openSourceProgram(DomainFile file) {
        try {
            VTSessionFileUtil.validateSourceProgramFile(file, false);
        }
        catch (Exception e) {
            this.setStatusMessage(e.getMessage());
            return null;
        }
        Program program = this.openProgram(file);
        if (program == null) {
            this.setStatusMessage("Open source program failed for " + file.getPathname());
        }
        return program;
    }

    private Program openDestinationProgram(DomainFile file) {
        try {
            VTSessionFileUtil.validateDestinationProgramFile(file, false, false);
        }
        catch (Exception e) {
            this.setStatusMessage(e.getMessage());
            return null;
        }
        Program program = this.openProgram(file);
        if (program == null) {
            this.setStatusMessage("Open destination program failed for " + file.getPathname());
        }
        return program;
    }

    private Program openProgram(DomainFile domainFile) {
        OpenProgramTask openProgramTask = new OpenProgramTask(domainFile, (Object)this.tool);
        new TaskLauncher((Task)openProgramTask, (Component)this.tool.getActiveWindow());
        OpenProgramRequest openProgramRequest = openProgramTask.getOpenProgram();
        return openProgramRequest != null ? openProgramRequest.getProgram() : null;
    }

    public JComponent getComponent() {
        return this.sessionPanel;
    }
}

