/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.plugin.core.debug.utils.AbstractMappedMemoryBytesVisitor;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.Icon;

public enum BasicAutoReadMemorySpec implements AutoReadMemorySpec
{
    NONE("0_READ_NONE", "Do Not Read Memory", DebuggerResources.AutoReadMemoryAction.ICON_NONE){

        public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
            return CompletableFuture.completedFuture(false);
        }
    }
    ,
    VISIBLE("1_READ_VISIBLE", "Read Visible Memory", DebuggerResources.AutoReadMemoryAction.ICON_VISIBLE){

        public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
            if (!coordinates.isAliveAndReadsPresent()) {
                return CompletableFuture.completedFuture(false);
            }
            Target target = coordinates.getTarget();
            TraceMemoryManager mm = coordinates.getTrace().getMemoryManager();
            AddressSetView alreadyKnown = mm.getAddressesWithState(coordinates.getSnap(), visible, s -> s == TraceMemoryState.KNOWN || s == TraceMemoryState.ERROR);
            AddressSet toRead = visible.subtract(alreadyKnown);
            if (toRead.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.doRead(tool, monitor -> target.readMemoryAsync((AddressSetView)toRead, monitor));
        }
    }
    ,
    VIS_RO_ONCE("2_READ_VIS_RO_ONCE", "Read Visible Memory, RO Once", DebuggerResources.AutoReadMemoryAction.ICON_VIS_RO_ONCE){

        public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
            long snap;
            if (!coordinates.isAliveAndReadsPresent()) {
                return CompletableFuture.completedFuture(false);
            }
            Target target = coordinates.getTarget();
            TraceMemoryManager mm = coordinates.getTrace().getMemoryManager();
            AddressSetView alreadyKnown = mm.getAddressesWithState(snap = coordinates.getSnap(), visible, s -> s == TraceMemoryState.KNOWN || s == TraceMemoryState.ERROR);
            AddressSet toRead = visible.subtract(alreadyKnown);
            if (toRead.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            AddressSet everKnown = new AddressSet();
            for (AddressRange range : visible) {
                for (Map.Entry ent : mm.getMostRecentStates(snap, range)) {
                    everKnown.add(((TraceAddressSnapRange)ent.getKey()).getRange());
                }
            }
            AddressSet readOnly = new AddressSet();
            for (AddressRange range : visible) {
                for (TraceMemoryRegion region : mm.getRegionsIntersecting(Lifespan.at((long)snap), range)) {
                    if (region.isWrite(snap)) continue;
                    readOnly.add(region.getRange(snap));
                }
            }
            toRead.delete((AddressSetView)everKnown.intersect((AddressSetView)readOnly));
            if (toRead.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.doRead(tool, monitor -> target.readMemoryAsync((AddressSetView)toRead, monitor));
        }
    }
    ,
    LOAD_EMULATOR(null, null, null){

        protected AddressSetView quantize(int blockBits, AddressSetView set) {
            if (blockBits == 1) {
                return set;
            }
            long blockMask = -1L << blockBits;
            AddressSet result = new AddressSet();
            for (AddressRange range : set) {
                AddressSpace space = range.getAddressSpace();
                Address min = space.getAddress(range.getMinAddress().getOffset() & blockMask);
                Address max = space.getAddress(range.getMaxAddress().getOffset() | blockMask ^ 0xFFFFFFFFFFFFFFFFL);
                result.add((AddressRange)new AddressRangeImpl(min, max));
            }
            return result;
        }

        public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
            CompletableFuture<Boolean> completableFuture;
            block12: {
                DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
                if (mappingService == null) {
                    return CompletableFuture.completedFuture(false);
                }
                Trace trace = coordinates.getTrace();
                if (trace == null || coordinates.isAlive() || !ProgramEmulationUtils.isEmulatedProgram(trace)) {
                    return CompletableFuture.completedFuture(false);
                }
                final TraceMemoryManager mm = trace.getMemoryManager();
                AddressSet toRead = new AddressSet(this.quantize(12, visible));
                for (Lifespan span : coordinates.getView().getViewport().getOrderedSpans()) {
                    AddressSetView alreadyKnown = mm.getAddressesWithState(span.lmin(), visible, s -> s == TraceMemoryState.KNOWN);
                    toRead.delete(alreadyKnown);
                    if (span.lmax() == span.lmin() && !toRead.isEmpty()) continue;
                    break;
                }
                if (toRead.isEmpty()) {
                    return CompletableFuture.completedFuture(false);
                }
                final long snap = coordinates.getSnap();
                final ByteBuffer buf = ByteBuffer.allocate(4096);
                Transaction tx = trace.openTransaction("Load Visible");
                try {
                    new AbstractMappedMemoryBytesVisitor(this, mappingService, buf.array()){

                        @Override
                        protected void visitData(Address hostAddr, byte[] data, int size) {
                            buf.position(0);
                            buf.limit(size);
                            mm.putBytes(snap, hostAddr, buf);
                        }
                    }.visit(trace, snap, (AddressSetView)toRead);
                    completableFuture = CompletableFuture.completedFuture(true);
                    if (tx == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MemoryAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                tx.close();
            }
            return completableFuture;
        }
    };

    private final String configName;
    private final String menuName;
    private final Icon menuIcon;

    private BasicAutoReadMemorySpec(String configName, String menuName, Icon menuIcon) {
        this.configName = configName;
        this.menuName = menuName;
        this.menuIcon = menuIcon;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public Icon getMenuIcon() {
        return this.menuIcon;
    }

    public AutoReadMemorySpec getEffective(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace != null && ProgramEmulationUtils.isEmulatedProgram(trace)) {
            return LOAD_EMULATOR;
        }
        return this;
    }

    protected CompletableFuture<Boolean> doRead(PluginTool tool, Function<TaskMonitor, CompletableFuture<Void>> reader) {
        return TargetActionTask.executeTask(tool, this.getMenuName(), true, true, false, m -> (CompletableFuture)reader.apply((TaskMonitor)m)).thenApply(__ -> true);
    }
}

