/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os;

import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.os.ErrorHandler;
import org.rzo.yajsw.os.FileManager;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.Keyboard;
import org.rzo.yajsw.os.Mouse;
import org.rzo.yajsw.os.ProcessManager;
import org.rzo.yajsw.os.ServiceManager;
import org.rzo.yajsw.os.SystemInformation;
import org.rzo.yajsw.os.ms.win.w32.OperatingSystemWindowsXP;
import org.rzo.yajsw.os.posix.bsd.OperatingSystemBSD;
import org.rzo.yajsw.os.posix.bsd.macosx.OperatingSystemMacOsX;
import org.rzo.yajsw.os.posix.linux.OperatingSystemLinux;
import org.rzo.yajsw.os.posix.solaris.OperatingSystemSolaris;

public abstract class OperatingSystem {
    static OperatingSystem _instance;
    static String _osName;
    static boolean _isPosix;

    public static OperatingSystem instance() {
        if (_instance != null) {
            return _instance;
        }
        _osName = System.getProperty("os.name");
        if (_osName.toLowerCase().startsWith("windows")) {
            _instance = new OperatingSystemWindowsXP();
            _isPosix = false;
        } else if (_osName.toLowerCase().startsWith("mac os x")) {
            _instance = new OperatingSystemMacOsX();
        } else if (_osName.contains("BSD")) {
            _instance = new OperatingSystemBSD();
        } else if (_osName.contains("AIX")) {
            _instance = new OperatingSystemBSD();
        } else if (_osName.toLowerCase().startsWith("linux")) {
            _instance = new OperatingSystemLinux();
        } else if (_osName.toLowerCase().contains("sunos")) {
            _instance = new OperatingSystemSolaris();
        }
        if (_instance == null) {
            System.out.println("OS not supported " + _osName);
        }
        return _instance;
    }

    public String getOperatingSystemName() {
        return _osName;
    }

    public boolean isPosix() {
        return _isPosix;
    }

    public abstract Keyboard keyboardInstance();

    public abstract Mouse mouseInstance();

    public abstract ProcessManager processManagerInstance();

    public abstract FileManager fileManagerInstance();

    public abstract ServiceManager serviceManagerInstance();

    public abstract ErrorHandler errorHandlerInstance();

    public abstract JavaHome getJavaHome(Configuration var1);

    public abstract Object getServiceFailureActions(Configuration var1);

    public abstract SystemInformation systemInformation();

    public abstract boolean setWorkingDir(String var1);

    public abstract long getUptime();

    public abstract void reboot();

    public abstract Map<String, String> getOSEnv();

    static {
        _isPosix = true;
    }
}

