/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.io.Serializable;
import java.util.Arrays;

public class ShortListIndexer
implements Serializable {
    private static final short END_OF_LIST = -1;
    private short[] heads;
    private short[] links;
    private short freePtr;
    private short size;
    private short capacity;
    private short numLists;

    public ShortListIndexer(short numLists, short capacity) {
        this.capacity = capacity;
        this.numLists = numLists;
        this.links = new short[capacity];
        this.heads = new short[numLists];
        this.clear();
    }

    public short add(short listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException();
        }
        short index = this.allocate();
        if (index >= 0) {
            this.links[index] = this.heads[listID];
            this.heads[listID] = index;
        }
        return index;
    }

    public short append(short listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException();
        }
        short index = this.allocate();
        if (index >= 0) {
            if (this.heads[listID] == -1) {
                this.heads[listID] = index;
            } else {
                short p = this.heads[listID];
                while (this.links[p] != -1) {
                    p = this.links[p];
                }
                this.links[p] = index;
            }
        }
        return index;
    }

    public void remove(short listID, short index) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException("The listID is out of bounds");
        }
        if (index < 0 || index >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        short head = this.heads[listID];
        if (head == -1) {
            return;
        }
        if (head == index) {
            short temp = this.links[head];
            this.free(head);
            this.heads[listID] = temp;
            return;
        }
        short ptr = head;
        while (this.links[ptr] != -1) {
            if (this.links[ptr] == index) {
                this.links[ptr] = this.links[index];
                this.free(index);
                break;
            }
            ptr = this.links[ptr];
        }
    }

    public void removeAll(short listID) {
        short head = this.heads[listID];
        this.heads[listID] = -1;
        while (head != -1) {
            short temp = head;
            head = this.links[head];
            this.free(temp);
        }
    }

    public short getNewCapacity() {
        if (this.capacity == Short.MAX_VALUE) {
            return -1;
        }
        short newCapacity = this.capacity < 16383 ? (short)(this.capacity * 2) : (short)Short.MAX_VALUE;
        return newCapacity;
    }

    public short getSize() {
        return this.size;
    }

    public short getCapacity() {
        return this.capacity;
    }

    public short getNumLists() {
        return this.numLists;
    }

    public final short next(short index) {
        return this.links[index];
    }

    public final short first(short listID) {
        return this.heads[listID];
    }

    public void growCapacity(short newCapacity) {
        if (newCapacity <= this.capacity) {
            return;
        }
        short[] temp = new short[newCapacity];
        System.arraycopy(this.links, 0, temp, 0, this.capacity);
        for (int i = this.capacity; i < newCapacity; ++i) {
            temp[i] = (short)(i + 1);
        }
        temp[newCapacity - 1] = -1;
        this.freePtr = this.capacity;
        this.capacity = newCapacity;
        this.links = temp;
    }

    public void growNumLists(short newListSize) {
        if (newListSize <= this.numLists) {
            return;
        }
        short[] temp = this.heads;
        this.heads = new short[newListSize];
        System.arraycopy(temp, 0, this.heads, 0, temp.length);
        Arrays.fill(this.heads, temp.length, this.heads.length, (short)-1);
        this.numLists = newListSize;
    }

    public void clear() {
        for (int i = 0; i < this.capacity; ++i) {
            this.links[i] = (short)(i + 1);
        }
        this.links[this.capacity - 1] = -1;
        this.freePtr = 0;
        Arrays.fill(this.heads, (short)-1);
        this.size = 0;
    }

    public int getListSize(short listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException("The listID is out of bounds");
        }
        int count = 0;
        short p = this.heads[listID];
        while (p != -1) {
            ++count;
            p = this.links[p];
        }
        return count;
    }

    private short allocate() {
        if (this.freePtr == -1) {
            this.growCapacity(this.getNewCapacity());
            if (this.freePtr == -1) {
                return -1;
            }
        }
        short p = this.freePtr;
        this.freePtr = this.links[this.freePtr];
        this.links[p] = -1;
        this.size = (short)(this.size + 1);
        return p;
    }

    private void free(short p) {
        this.size = (short)(this.size - 1);
        this.links[p] = this.freePtr;
        this.freePtr = p;
    }
}

