/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressTranslationException;
import ghidra.program.util.AddressTranslator;
import java.util.HashMap;

public class ExternalsAddressTranslator
implements AddressTranslator {
    protected Program destinationProgram;
    protected Program sourceProgram;
    HashMap<Address, Address> addressMap = new HashMap();

    public ExternalsAddressTranslator(Program destinationProgram, Program sourceProgram) {
        this.destinationProgram = destinationProgram;
        this.sourceProgram = sourceProgram;
    }

    @Override
    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    @Override
    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    public void setPair(Address destinationAddress, Address sourceAddress) {
        if (destinationAddress != null) {
            this.addressMap.put(sourceAddress, destinationAddress);
        } else {
            this.addressMap.remove(sourceAddress);
        }
    }

    @Override
    public Address getAddress(Address sourceAddress) {
        Address destinationAddress = this.addressMap.get(sourceAddress);
        if (destinationAddress != null) {
            return destinationAddress;
        }
        throw new AddressTranslationException("The specified source address never had an external address pair added to the translator.");
    }

    @Override
    public boolean isOneForOneTranslator() {
        return true;
    }

    @Override
    public AddressSet getAddressSet(AddressSetView sourceAddressSet) {
        if (sourceAddressSet == null) {
            return null;
        }
        if (sourceAddressSet.getNumAddresses() > 1L) {
            throw new AddressTranslationException("An external address translator can only handle a single address at a time, if that.");
        }
        AddressSet destinationSet = new AddressSet();
        if (sourceAddressSet.isEmpty()) {
            return destinationSet;
        }
        Address sourceAddress = sourceAddressSet.getMinAddress();
        Address destinationAddress = this.addressMap.get(sourceAddress);
        if (destinationAddress != null) {
            destinationSet.add(destinationAddress);
        }
        throw new AddressTranslationException("The specified source address set never had an external address pair added to the translator.");
    }

    @Override
    public AddressRange getAddressRange(AddressRange sourceAddressRange) throws AddressTranslationException {
        if (sourceAddressRange == null) {
            return null;
        }
        if (sourceAddressRange.getLength() != 1L) {
            throw new AddressTranslationException("An external address translator can only handle a single address at a time, if that.");
        }
        Address sourceAddress = sourceAddressRange.getMinAddress();
        Address destinationAddress = this.addressMap.get(sourceAddress);
        if (destinationAddress != null) {
            return new AddressRangeImpl(destinationAddress, destinationAddress);
        }
        throw new AddressTranslationException("The specified source address range never had an external address pair added to the translator.");
    }
}

