/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.GolangSymbolAnalyzer;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoString;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.function.Predicate;

public class GolangStringAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Golang Strings";
    private static final String DESCRIPTION = "Finds and labels Golang string structures.";
    private GolangStringAnalyzerOptions analyzerOptions = new GolangStringAnalyzerOptions();
    private GoRttiMapper goBinary;
    private Program program;
    private MarkupSession markupSession;
    private GoParamStorageAllocator storageAllocator;
    private int stringStructLen;
    private int sliceStructLen;

    public GolangStringAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(GolangSymbolAnalyzer.STRINGS_PRIORITY);
        this.setDefaultEnablement(true);
    }

    @Override
    public void registerOptions(Options options, Program program_notused) {
        this.analyzerOptions.registerOptions(options);
    }

    @Override
    public void optionsChanged(Options options, Program program_notused) {
        this.analyzerOptions.optionsChanged(options);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return GoRttiMapper.isGolangProgram(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.program = program;
        this.goBinary = GoRttiMapper.getSharedGoBinary(program, monitor);
        if (this.goBinary == null) {
            Msg.error((Object)this, (Object)"Golang string analyzer error: unable to get GoRttiMapper");
            return false;
        }
        this.sliceStructLen = this.goBinary.getStructureMappingInfo(GoSlice.class).getStructureLength();
        this.stringStructLen = this.goBinary.getStructureMappingInfo(GoString.class).getStructureLength();
        this.markupSession = this.goBinary.createMarkupSession(monitor);
        this.storageAllocator = this.goBinary.newStorageAllocator();
        int stringCount = 0;
        try {
            stringCount = this.markupStaticStructRefsInFunctions(set, monitor);
            if (this.analyzerOptions.markupDataSegmentStructs) {
                stringCount += this.markupDataSegmentStructs(monitor);
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Golang analysis failure", (Throwable)e);
        }
        Msg.info((Object)this, (Object)"Golang strings found: %d".formatted(stringCount));
        return true;
    }

    private static boolean alignStartOfSet(AddressSet set, int align) {
        while (!set.isEmpty()) {
            Address addr = set.getMinAddress();
            int mod = (int)(addr.getOffset() % (long)align);
            if (mod == 0) {
                return true;
            }
            AddressRange range = set.getFirstRange();
            set.deleteFromMin(range.contains(addr = addr.add((long)(align - mod - 1))) ? addr : range.getMaxAddress());
        }
        return false;
    }

    private int markupStaticStructRefsInFunctions(AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor = new UnknownProgressWrappingTaskMonitor(monitor);
        monitor.initialize(1L, "Searching for Golang structure references in functions");
        FunctionManager funcManager = this.goBinary.getProgram().getFunctionManager();
        int stringCount = 0;
        for (Function function : funcManager.getFunctions(set, true)) {
            monitor.checkCancelled();
            stringCount += this.markupStaticStructRefsInFunction(function, monitor);
        }
        return stringCount;
    }

    private int markupStaticStructRefsInFunction(Function function, TaskMonitor monitor) throws IOException, CancelledException {
        ReferenceManager refManager = this.goBinary.getProgram().getReferenceManager();
        Listing listing = this.goBinary.getProgram().getListing();
        int stringCount = 0;
        AddressSet stringDataRange = new AddressSet(this.goBinary.getStringDataRange());
        AddressSetView validStructRange = this.goBinary.getStringStructRange();
        AddressSetView funcBody = function.getBody();
        for (Reference ref : refManager.getReferenceIterator(function.getEntryPoint())) {
            Instruction instr;
            GoString inlineStr;
            monitor.increment();
            if (!funcBody.contains(ref.getFromAddress())) break;
            Address addr = ref.getToAddress();
            if (ref.getReferenceType() != RefType.DATA || !validStructRange.contains(addr) || !this.canCreateStructAt(addr)) continue;
            if (this.tryCreateStruct(stringDataRange, addr) != null) {
                ++stringCount;
                continue;
            }
            if (!stringDataRange.contains(addr) || (inlineStr = this.tryCreateInlineString(funcBody, stringDataRange, addr, instr = listing.getInstructionContaining(ref.getFromAddress()), this::isValidStringData)) == null) continue;
            inlineStr.additionalMarkup(this.markupSession);
            ++stringCount;
        }
        return stringCount;
    }

    private GoString tryCreateInlineString(AddressSetView funcBody, AddressSet stringDataRange, Address stringDataAddr, Instruction instr1, Predicate<String> stringContentValidator) {
        Instruction instr2 = instr1.getNext();
        if (instr2 == null || !funcBody.contains(instr2.getAddress())) {
            return null;
        }
        Register strAddrReg = this.getRegisterFromInstr(instr1);
        Register strLenReg = this.storageAllocator.getNextIntParamRegister(strAddrReg);
        if (strLenReg != null && strLenReg.contains(this.getRegisterFromInstr(instr2))) {
            long strLen = this.getScalarFromInstr(instr2);
            try {
                GoString str = GoString.createInlineString(this.goBinary, stringDataAddr, strLen);
                if (str.isValidInlineString((AddressSetView)stringDataRange, stringContentValidator)) {
                    return str;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private Register getRegisterFromInstr(Instruction instr) {
        if (instr.getNumOperands() != 2 || instr.getOperandType(0) != 512) {
            return null;
        }
        return (Register)instr.getOpObjects(0)[0];
    }

    private long getScalarFromInstr(Instruction instr) {
        long l;
        if (instr.getNumOperands() != 2) {
            return -1L;
        }
        Object operand1Obj0 = instr.getOpObjects(1)[0];
        if (instr.getOperandType(1) == 16384 && operand1Obj0 instanceof Scalar) {
            Scalar s = (Scalar)operand1Obj0;
            l = s.getUnsignedValue();
        } else {
            l = -1L;
        }
        return l;
    }

    private int markupDataSegmentStructs(TaskMonitor monitor) throws IOException, CancelledException {
        AddressSet structDataRange = new AddressSet(this.goBinary.getStringStructRange());
        structDataRange.delete((AddressSetView)this.markupSession.getMarkedupAddresses());
        AddressSet stringDataRange = new AddressSet(this.goBinary.getStringDataRange());
        long initAddrCount = structDataRange.getNumAddresses();
        monitor.initialize(initAddrCount, "Searching for Golang strings & structures in data segments");
        int stringCount = 0;
        int sliceCount = 0;
        int align = this.goBinary.getPtrSize();
        while (GolangStringAnalyzer.alignStartOfSet(structDataRange, align)) {
            monitor.setProgress(initAddrCount - structDataRange.getNumAddresses());
            monitor.checkCancelled();
            Address addr = structDataRange.getMinAddress();
            structDataRange.deleteFromMin(addr);
            Object newObj = this.tryCreateStruct(stringDataRange, addr);
            if (newObj != null) {
                structDataRange.deleteFromMin(this.goBinary.getMaxAddressOfStructure(newObj));
                monitor.setMessage("Searching for Golang strings & slices in data segments: %d+%d".formatted(stringCount += newObj instanceof GoString ? 1 : 0, sliceCount += newObj instanceof GoSlice ? 1 : 0));
                continue;
            }
            Data data = this.goBinary.getProgram().getListing().getDataContaining(addr);
            if (data == null) continue;
            structDataRange.deleteFromMin(data.getMaxAddress());
        }
        return stringCount;
    }

    private Object tryCreateStruct(AddressSet stringDataRange, Address addr) throws IOException, CancelledException {
        StructureMarkup<GoSlice> newObj;
        boolean isUndefined3x = DataUtilities.isUndefinedRange((Program)this.program, (Address)addr, (Address)addr.add((long)this.sliceStructLen));
        boolean isUndefined2x = isUndefined3x || DataUtilities.isUndefinedRange((Program)this.program, (Address)addr, (Address)addr.add((long)this.stringStructLen));
        GoSlice goSlice = newObj = isUndefined3x ? this.tryReadSliceStruct(addr) : null;
        if (newObj == null && isUndefined2x) {
            newObj = this.tryReadStringStruct((AddressSetView)stringDataRange, addr);
        }
        if (newObj != null) {
            boolean doMarkup;
            boolean bl = doMarkup = this.analyzerOptions.markupSliceStructs || !(newObj instanceof GoSlice);
            if (doMarkup) {
                this.markupSession.markup(newObj, false);
                if (newObj instanceof GoString) {
                    GoString goStr = (GoString)newObj;
                    stringDataRange.delete(goStr.getStringDataRange());
                }
            }
        }
        return newObj;
    }

    private GoString tryReadStringStruct(AddressSetView stringDataRange, Address addr) {
        try {
            GoString goString = this.goBinary.readStructure(GoString.class, addr);
            if (goString.isValid(stringDataRange, this::isValidStringData)) {
                return goString;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean isValidStringData(String s) {
        return s != null && !s.codePoints().anyMatch(this::isBadCodePoint);
    }

    private boolean isBadCodePoint(int codePoint) {
        return codePoint == 65533 || 0 <= codePoint && codePoint < 32 && codePoint != 10 && codePoint != 9;
    }

    private GoSlice tryReadSliceStruct(Address addr) {
        try {
            GoSlice slice = this.goBinary.readStructure(GoSlice.class, addr);
            if (slice.getLen() != 0L && slice.isFull() && slice.isValid()) {
                return slice;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean canCreateStructAt(Address addr) {
        Pointer ptr;
        DataType dataType;
        Data data = this.goBinary.getProgram().getListing().getDataContaining(addr);
        return data == null || !data.isDefined() || Undefined.isUndefined((DataType)data.getDataType()) || (dataType = data.getDataType()) instanceof Pointer && (ptr = (Pointer)dataType).getDataType() == null;
    }

    private static class GolangStringAnalyzerOptions {
        static final String MARKUP_SLICES_OPTIONNAME = "Markup slices";
        static final String MARKUP_SLICES_DESC = "Markup things that look like slices.";
        static final String MARKUP_STRUCTS_IN_DATA_OPTIONNAME = "Search data segments";
        static final String MARKUP_STRUCTS_IN_DATA_DESC = "Search for strings and slices in data segments.";
        boolean markupSliceStructs = true;
        boolean markupDataSegmentStructs = true;

        private GolangStringAnalyzerOptions() {
        }

        void registerOptions(Options options) {
            options.registerOption(MARKUP_SLICES_OPTIONNAME, (Object)this.markupSliceStructs, null, MARKUP_SLICES_DESC);
            options.registerOption(MARKUP_STRUCTS_IN_DATA_OPTIONNAME, (Object)this.markupDataSegmentStructs, null, MARKUP_STRUCTS_IN_DATA_DESC);
        }

        void optionsChanged(Options options) {
            this.markupDataSegmentStructs = options.getBoolean(MARKUP_STRUCTS_IN_DATA_OPTIONNAME, this.markupDataSegmentStructs);
            this.markupSliceStructs = options.getBoolean(MARKUP_SLICES_OPTIONNAME, this.markupSliceStructs);
        }
    }
}

