/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.dnd.GenericDataFlavor;
import ghidra.app.plugin.core.programtree.ProgramNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProgramTreeTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localTreeNodeFlavor = ProgramTreeTransferable.createLocalTreeNodeFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localTreeNodeFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private List<ProgramNode> nodeList;

    private static DataFlavor createLocalTreeNodeFlavor() {
        return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.ArrayList", "Local list of Tree Nodes");
    }

    ProgramTreeTransferable(ProgramNode[] nodes) {
        this.nodeList = new ArrayList<ProgramNode>(Arrays.asList(nodes));
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localTreeNodeFlavor)) {
            return this.nodeList;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "TreeTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    void clearTransferData() {
        this.nodeList = null;
    }
}

