/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffRelocation
implements StructConverter {
    private static final int SIZEOF2 = 12;
    private static final int SIZEOF = 10;
    private int r_vaddr;
    private int r_symndx;
    private short r_exa;
    private short r_type;
    private CoffFileHeader _header;

    CoffRelocation(BinaryReader reader, CoffFileHeader header) throws IOException {
        this._header = header;
        this.r_vaddr = reader.readNextInt();
        this.r_symndx = reader.readNextInt();
        if (header.getMagic() == 194) {
            this.r_exa = reader.readNextShort();
        }
        this.r_type = reader.readNextShort();
    }

    public int sizeof() {
        if (this._header.getMagic() == 194 || this._header.getMagic() == 193) {
            return 12;
        }
        return 10;
    }

    public long getAddress() {
        return this.r_vaddr;
    }

    public long getSymbolIndex() {
        return this.r_symndx;
    }

    public short getExtendedAddress() {
        return this.r_exa;
    }

    public short getType() {
        return this.r_type;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(CoffRelocation.class), 0);
        struct.add(DWORD, "r_vaddr", null);
        struct.add(DWORD, "r_symndx", null);
        if (this._header.getMagic() == 194 || this._header.getMagic() == 193) {
            struct.add(WORD, "r_exa", null);
        }
        struct.add(WORD, "r_type", null);
        return struct;
    }
}

