/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFIndirectTableHeader;
import ghidra.app.util.bin.format.dwarf.DWARFLengthValue;
import java.io.IOException;

public class DWARFRangeListHeader
extends DWARFIndirectTableHeader {
    private final int offsetEntryCount;
    private final int offsetIntSize;
    private final int addressSize;
    private final int segmentSelectorSize;

    public static DWARFRangeListHeader read(BinaryReader reader, int defaultIntSize) throws IOException {
        long startOffset = reader.getPointerIndex();
        DWARFLengthValue lengthInfo = DWARFLengthValue.read(reader, defaultIntSize);
        if (lengthInfo == null) {
            return null;
        }
        long endOffset = reader.getPointerIndex() + lengthInfo.length();
        short version = reader.readNextShort();
        if (version != 5) {
            throw new DWARFException("DWARFRangeList (%x): unsupported DWARF version [%d]".formatted(startOffset, version));
        }
        int addressSize = reader.readNextUnsignedByte();
        int segmentSelectorSize = reader.readNextUnsignedByte();
        int offsetEntryCount = reader.readNextUnsignedIntExact();
        long offsetListPosition = reader.getPointerIndex();
        reader.setPointerIndex(endOffset);
        if (segmentSelectorSize != 0) {
            throw new IOException("Unsupported segmentSelectorSize: " + segmentSelectorSize);
        }
        return new DWARFRangeListHeader(startOffset, endOffset, offsetListPosition, lengthInfo.intSize(), offsetEntryCount, addressSize, segmentSelectorSize);
    }

    public DWARFRangeListHeader(long startOffset, long endOffset, long firstElementOffset, int offsetIntSize, int offsetEntryCount, int addressSize, int segmentSelectorSize) {
        super(startOffset, endOffset, firstElementOffset);
        this.offsetIntSize = offsetIntSize;
        this.offsetEntryCount = offsetEntryCount;
        this.addressSize = addressSize;
        this.segmentSelectorSize = segmentSelectorSize;
    }

    @Override
    public long getOffset(int index, BinaryReader reader) throws IOException {
        if (index < 0 || this.offsetEntryCount <= index) {
            throw new IOException("Invalid range list index: " + index);
        }
        return this.firstElementOffset + reader.readUnsignedValue(this.firstElementOffset + (long)(index * this.offsetIntSize), this.offsetIntSize);
    }
}

