/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.Nullable;

public abstract class IoActions {
    public static void writeTextFile(File output, String encoding, Action<? super BufferedWriter> action) {
        IoActions.createTextFileWriteAction(output, encoding).execute(action);
    }

    public static void writeTextFile(File output, Action<? super BufferedWriter> action) {
        IoActions.writeTextFile(output, Charset.defaultCharset().name(), action);
    }

    public static Action<Action<? super BufferedWriter>> createTextFileWriteAction(File output, String encoding) {
        return new TextFileWriterIoAction(output, encoding);
    }

    public static <T extends Closeable> void withResource(T resource, Action<? super T> action) {
        try {
            action.execute(resource);
        }
        catch (Throwable t) {
            IoActions.closeQuietly(resource);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        IoActions.uncheckedClose(resource);
    }

    public static <T extends Closeable, R> R withResource(T resource, Function<? super T, R> action) {
        R result;
        try {
            result = action.apply(resource);
        }
        catch (Throwable t) {
            IoActions.closeQuietly(resource);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        IoActions.uncheckedClose(resource);
        return result;
    }

    public static void uncheckedClose(@Nullable Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static void closeQuietly(@Nullable Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class TextFileWriterIoAction
    implements Action<Action<? super BufferedWriter>> {
        private final File file;
        private final String encoding;

        private TextFileWriterIoAction(File file, String encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        @Override
        public void execute(Action<? super BufferedWriter> action) {
            try {
                File parentFile = this.file.getParentFile();
                if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
                    throw new IOException(String.format("Unable to create directory '%s'", parentFile));
                }
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), this.encoding));){
                    action.execute(writer);
                }
            }
            catch (FileSystemException e) {
                throw new UncheckedIOException(String.format("%s: '%s'.", e.getReason(), this.file), e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Could not write to file '%s'.", this.file), e);
            }
        }
    }
}

