/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public final class ImportStaticIntention
extends Intention {
    private static final Key<PsiElement> TEMP_REFERENT_USER_DATA = new Key("TEMP_REFERENT_USER_DATA");

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        PsiElement resolved;
        if (element == null) {
            ImportStaticIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ImportStaticIntention.$$$reportNull$$$0(1);
        }
        if (!((resolved = ImportStaticIntention.resolve(element)) instanceof PsiMember)) {
            return;
        }
        PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
        if (containingClass == null) {
            return;
        }
        String originalName = ((PsiMember)resolved).getName();
        final String name = resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)resolved) ? GroovyPropertyUtils.getPropertyName((PsiMethod)resolved) : originalName;
        String qname = containingClass.getQualifiedName();
        if (name == null) {
            return;
        }
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return;
        }
        GroovyFile file = (GroovyFile)containingFile;
        file.accept(new GroovyRecursiveElementVisitor(this){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
                PsiElement resolved;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                if (name.equals(expression.getReferenceName()) && (resolved = expression.resolve()) != null) {
                    expression.putUserData(TEMP_REFERENT_USER_DATA, resolved);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/intentions/style/ImportStaticIntention$1", "visitReferenceExpression"));
            }
        });
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrImportStatement tempImport = factory.createImportStatementFromText(qname + "." + name, true, false, null);
        GrImportStatement importStatement = file.addImport(tempImport);
        boolean isAnythingShortened = ImportStaticIntention.shortenUsages(resolved, containingFile);
        if (!isAnythingShortened) {
            importStatement.delete();
            return;
        }
        file.accept(new GroovyRecursiveElementVisitor(this){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                GrTypeArgumentList typeArgumentList = expression.getTypeArgumentList();
                if (typeArgumentList != null && typeArgumentList.getFirstChild() != null) {
                    expression.putUserData(TEMP_REFERENT_USER_DATA, null);
                    return;
                }
                if (name.equals(expression.getReferenceName())) {
                    if (expression.isQualified()) {
                        PsiElement aClass;
                        GrExpression qualifier = expression.getQualifierExpression();
                        if (qualifier instanceof GrReferenceExpression && (aClass = ((GrReferenceExpression)qualifier).resolve()) == ((PsiMember)resolved).getContainingClass()) {
                            GrReferenceAdjuster.shortenReference(expression);
                        }
                    } else {
                        PsiElement referent = (PsiElement)expression.getUserData(TEMP_REFERENT_USER_DATA);
                        if (referent instanceof PsiMember && ((PsiMember)referent).hasModifierProperty("static") && referent != expression.resolve()) {
                            expression.bindToElement(referent);
                        }
                    }
                }
                expression.putUserData(TEMP_REFERENT_USER_DATA, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/intentions/style/ImportStaticIntention$2", "visitReferenceExpression"));
            }
        });
    }

    private static boolean shortenUsages(PsiElement resolved, PsiFile containingFile) {
        boolean isAnythingShortened = false;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)resolved, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).asIterable()) {
            PsiElement refElement = reference.getElement();
            if (!(refElement instanceof GrQualifiedReference)) continue;
            boolean shortened = GrReferenceAdjuster.shortenReference((GrQualifiedReference)refElement);
            isAnythingShortened |= shortened;
        }
        return isAnythingShortened;
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return super.isStopElement(element) || element instanceof GrReferenceExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(this){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement resolved;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((resolved = ImportStaticIntention.resolve(element)) == null) {
                    return false;
                }
                return resolved instanceof PsiMember && !(resolved instanceof PsiClass) && ((PsiMember)resolved).hasModifierProperty("static") && ((PsiMember)resolved).getContainingClass() != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ImportStaticIntention$3", "satisfiedBy"));
            }
        };
    }

    @Nullable
    private static PsiElement resolve(PsiElement element) {
        GrReferenceExpression ref2 = ImportStaticIntention.findRef(element);
        if (ref2 == null || ref2.getQualifier() == null) {
            return null;
        }
        return ref2.resolve();
    }

    @Nullable
    private static GrReferenceExpression findRef(PsiElement element) {
        GrExpression invoked;
        PsiElement parent;
        if (element instanceof GrReferenceExpression) {
            return (GrReferenceExpression)element;
        }
        if (element instanceof GrArgumentList && (parent = element.getParent()) instanceof GrMethodCall && (invoked = ((GrMethodCall)parent).getInvokedExpression()) instanceof GrReferenceExpression) {
            return (GrReferenceExpression)invoked;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/style/ImportStaticIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

