/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import net.sf.juife.InformationDialog;
import net.sf.juife.JuifeUtils;
import net.sf.juife.NavigationPage;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.event.AudioDeviceEvent;
import org.jsampler.event.AudioDeviceListener;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.view.NumberCellEditor;
import org.jsampler.view.ParameterTable;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.AudioDevicesTableModel;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.linuxsampler.lscp.AudioOutputChannel;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.Parameter;

public class AudioDevicesPage
extends NavigationPage {
    private final Action duplicateAudioDevice = new DuplicateAudioDevice();
    private final Action removeAudioDevice = new RemoveAudioDevice();
    private final Action audioDeviceProps = new AudioDeviceProps();
    private final ToolbarButton btnNewDevice = new ToolbarButton(A4n.addAudioDevice);
    private final ToolbarButton btnDuplicateDevice = new ToolbarButton(this.duplicateAudioDevice);
    private final ToolbarButton btnRemoveDevice = new ToolbarButton(this.removeAudioDevice);
    private final ToolbarButton btnDeviceProps = new ToolbarButton(this.audioDeviceProps);
    private final JTable devicesTable = new JTable(new AudioDevicesTableModel());
    private final JLabel lChannels = new JLabel(ClassicI18n.i18n.getLabel("AudioDevicesPage.lChannels"));
    private final JComboBox cbChannels = new JComboBox();
    ParameterTable channelParamTable = new ParameterTable();
    private final Handler handler = new Handler();

    public AudioDevicesPage() {
        this.setTitle(ClassicI18n.i18n.getLabel("AudioDevicesPage.title"));
        this.cbChannels.setEnabled(false);
        TableColumn tableColumn = this.devicesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(tableColumn.getMinWidth());
        NumberCellEditor numberCellEditor = new NumberCellEditor();
        numberCellEditor.setMinimum(Integer.valueOf(0));
        numberCellEditor.setMaximum(Integer.valueOf(255));
        tableColumn = this.devicesTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(numberCellEditor);
        this.setLayout(new BoxLayout(this, 1));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMaximumSize(new Dimension(Short.MAX_VALUE, jToolBar.getPreferredSize().height));
        jToolBar.setFloatable(false);
        jToolBar.setAlignmentX(1.0f);
        jToolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        jToolBar.add(new JLabel(Res.iconVol24));
        jToolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        jToolBar.add(this.btnNewDevice);
        jToolBar.add(this.btnDuplicateDevice);
        jToolBar.add(this.btnRemoveDevice);
        jToolBar.addSeparator();
        jToolBar.add(this.btnDeviceProps);
        this.add(jToolBar);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setContinuousLayout(true);
        this.devicesTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.devicesTable);
        Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        jSplitPane.setTopComponent(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lChannels);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.cbChannels);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(jPanel);
        jScrollPane = new JScrollPane(this.channelParamTable);
        dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
        jScrollPane.setPreferredSize(dimension);
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(jScrollPane);
        jPanel2.add(jPanel);
        jPanel2.setBorder(BorderFactory.createTitledBorder(ClassicI18n.i18n.getLabel("AudioDevicesPage.channels")));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jPanel2);
        jSplitPane.setBottomComponent(jPanel);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jSplitPane.setAlignmentX(1.0f);
        jSplitPane.setDividerSize(3);
        this.add(jSplitPane);
        jSplitPane.setDividerLocation(150);
        this.cbChannels.addActionListener(this.getHandler());
        this.devicesTable.getSelectionModel().addListSelectionListener(this.getHandler());
        this.channelParamTable.getModel().addParameterListener(this.getHandler());
    }

    private AudioDeviceModel getSelectedAudioDeviceModel() {
        ListSelectionModel listSelectionModel = this.devicesTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return ((AudioDevicesTableModel)this.devicesTable.getModel()).getAudioDeviceModel(listSelectionModel.getMinSelectionIndex());
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class DevicePropsDlg
    extends InformationDialog {
        DevicePropsDlg() {
            super((Frame)CC.getMainFrame(), ClassicI18n.i18n.getLabel("AudioDevicesPage.DevicePropsDlg"));
            AudioDeviceModel audioDeviceModel = AudioDevicesPage.this.getSelectedAudioDeviceModel();
            ParameterTable parameterTable = new ParameterTable();
            parameterTable.getModel().setParameters(audioDeviceModel.getDeviceInfo().getAdditionalParameters());
            JScrollPane jScrollPane = new JScrollPane(parameterTable);
            jScrollPane.setPreferredSize(JuifeUtils.getUnionSize(jScrollPane.getMinimumSize(), new Dimension(200, 200)));
            this.setMainPane(jScrollPane);
        }
    }

    private class AudioDeviceProps
    extends AbstractAction {
        AudioDeviceProps() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttAudioDeviceProps"));
            try {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("org/jsampler/view/classic/res/icons/Properties16.gif");
                ImageIcon imageIcon = new ImageIcon(uRL);
                if (imageIcon.getImageLoadStatus() == 8) {
                    this.putValue("SmallIcon", imageIcon);
                }
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new DevicePropsDlg().setVisible(true);
        }
    }

    private class RemoveAudioDevice
    extends AbstractAction {
        RemoveAudioDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttRemoveAudioDevice"));
            try {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("org/jsampler/view/classic/res/icons/Delete16.gif");
                ImageIcon imageIcon = new ImageIcon(uRL);
                if (imageIcon.getImageLoadStatus() == 8) {
                    this.putValue("SmallIcon", imageIcon);
                }
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioDeviceModel audioDeviceModel = AudioDevicesPage.this.getSelectedAudioDeviceModel();
            if (audioDeviceModel == null) {
                CC.getLogger().warning("No selected audio device to remove!");
                return;
            }
            CC.getSamplerModel().removeBackendAudioDevice(audioDeviceModel.getDeviceId());
        }
    }

    private class DuplicateAudioDevice
    extends AbstractAction {
        DuplicateAudioDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttDuplicateAudioDevice"));
            try {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("org/jsampler/view/classic/res/icons/Copy16.gif");
                ImageIcon imageIcon = new ImageIcon(uRL);
                if (imageIcon.getImageLoadStatus() == 8) {
                    this.putValue("SmallIcon", imageIcon);
                }
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(CC.getMainFrame(), "Not implemented yet", "", 1);
            AudioDeviceModel audioDeviceModel = AudioDevicesPage.this.getSelectedAudioDeviceModel();
            if (audioDeviceModel == null) {
                CC.getLogger().warning("No selected audio device to duplicate!");
                return;
            }
        }
    }

    private class Handler
    implements ActionListener,
    ListSelectionListener,
    AudioDeviceListener,
    ParameterListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = AudioDevicesPage.this.cbChannels.getSelectedItem();
            if (object == null) {
                AudioDevicesPage.this.channelParamTable.getModel().setParameters(new Parameter[0]);
                return;
            }
            AudioOutputChannel audioOutputChannel = (AudioOutputChannel)object;
            AudioDevicesPage.this.channelParamTable.getModel().setParameters(audioOutputChannel.getAllParameters());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            for (AudioDeviceModel audioDeviceModel : CC.getSamplerModel().getAudioDevices()) {
                audioDeviceModel.removeAudioDeviceListener(this);
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                AudioDevicesPage.this.duplicateAudioDevice.setEnabled(false);
                AudioDevicesPage.this.removeAudioDevice.setEnabled(false);
                AudioDevicesPage.this.audioDeviceProps.setEnabled(false);
                AudioDevicesPage.this.cbChannels.removeAllItems();
                AudioDevicesPage.this.cbChannels.setEnabled(false);
                return;
            }
            AudioDevicesPage.this.duplicateAudioDevice.setEnabled(true);
            AudioDevicesPage.this.removeAudioDevice.setEnabled(true);
            AudioDevicesPage.this.audioDeviceProps.setEnabled(true);
            AudioDeviceModel audioDeviceModel = ((AudioDevicesTableModel)AudioDevicesPage.this.devicesTable.getModel()).getAudioDeviceModel(listSelectionModel.getMinSelectionIndex());
            AudioDevicesPage.this.cbChannels.removeAllItems();
            for (AudioOutputChannel audioOutputChannel : audioDeviceModel.getDeviceInfo().getAudioChannels()) {
                AudioDevicesPage.this.cbChannels.addItem(audioOutputChannel);
            }
            AudioDevicesPage.this.cbChannels.setEnabled(true);
            audioDeviceModel.addAudioDeviceListener(this);
        }

        @Override
        public void settingsChanged(AudioDeviceEvent audioDeviceEvent) {
            AudioOutputDevice audioOutputDevice = audioDeviceEvent.getAudioDeviceModel().getDeviceInfo();
            int n = AudioDevicesPage.this.cbChannels.getSelectedIndex();
            AudioDevicesPage.this.cbChannels.removeAllItems();
            for (AudioOutputChannel audioOutputChannel : audioOutputDevice.getAudioChannels()) {
                AudioDevicesPage.this.cbChannels.addItem(audioOutputChannel);
            }
            if (n >= AudioDevicesPage.this.cbChannels.getModel().getSize()) {
                n = 0;
            }
            if (AudioDevicesPage.this.cbChannels.getModel().getSize() > 0) {
                AudioDevicesPage.this.cbChannels.setSelectedIndex(n);
            }
        }

        @Override
        public void parameterChanged(ParameterEvent parameterEvent) {
            AudioDeviceModel audioDeviceModel = AudioDevicesPage.this.getSelectedAudioDeviceModel();
            if (audioDeviceModel == null) {
                CC.getLogger().warning("Unexpected null AudioDeviceModel!");
                return;
            }
            int n = AudioDevicesPage.this.cbChannels.getSelectedIndex();
            if (n == -1) {
                CC.getLogger().warning("There is no audio channel selected!");
                return;
            }
            audioDeviceModel.setBackendChannelParameter(n, parameterEvent.getParameter());
        }
    }
}

