/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;

public class DelayedShareFetchPartitionKey
implements DelayedShareFetchKey {
    private final Uuid topicId;
    private final int partition;

    public DelayedShareFetchPartitionKey(TopicIdPartition topicIdPartition) {
        this(topicIdPartition.topicId(), topicIdPartition.partition());
    }

    public DelayedShareFetchPartitionKey(Uuid topicId, int partition) {
        this.topicId = topicId;
        this.partition = partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayedShareFetchPartitionKey that = (DelayedShareFetchPartitionKey)o;
        return this.topicId.equals((Object)that.topicId) && this.partition == that.partition;
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.partition);
    }

    public String toString() {
        return "DelayedShareFetchPartitionKey(topicId=" + String.valueOf(this.topicId) + ", partition=" + this.partition + ")";
    }

    public String keyLabel() {
        return String.format("topicId=%s, partition=%s", this.topicId, this.partition);
    }
}

