/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.stream.Stream;
import org.keycloak.common.util.Time;
import org.keycloak.models.jpa.entities.RevokedTokenEntity;
import org.keycloak.models.session.RevokedToken;
import org.keycloak.models.session.RevokedTokenPersisterProvider;

public class JpaRevokedTokensPersisterProvider
implements RevokedTokenPersisterProvider {
    private final EntityManager em;

    public JpaRevokedTokensPersisterProvider(EntityManager em) {
        this.em = em;
    }

    public void revokeToken(String tokenId, long lifetime) {
        RevokedTokenEntity revokedTokenEntity = (RevokedTokenEntity)this.em.find(RevokedTokenEntity.class, (Object)tokenId);
        long expire = (long)Time.currentTime() + lifetime;
        if (revokedTokenEntity != null) {
            if (revokedTokenEntity.getExpire() < expire) {
                revokedTokenEntity.setExpire(expire);
            }
            return;
        }
        revokedTokenEntity = new RevokedTokenEntity();
        revokedTokenEntity.setId(tokenId);
        revokedTokenEntity.setExpire(expire);
        this.em.persist((Object)revokedTokenEntity);
    }

    public Stream<RevokedToken> getAllRevokedTokens() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(RevokedTokenEntity.class);
        Root rootEntry = cq.from(RevokedTokenEntity.class);
        CriteriaQuery all = cq.select((Selection)rootEntry).where((Expression)cb.gt((Expression)rootEntry.get("expire"), (Number)Time.currentTime()));
        TypedQuery allQuery = this.em.createQuery(all);
        return allQuery.getResultStream().map(revokedTokenEntity -> new RevokedToken(revokedTokenEntity.getId(), revokedTokenEntity.getExpire()));
    }

    public void expireTokens() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete cd = cb.createCriteriaDelete(RevokedTokenEntity.class);
        Root rootEntry = cd.from(RevokedTokenEntity.class);
        cd.where((Expression)cb.lt((Expression)rootEntry.get("expire"), (Number)Time.currentTime()));
        this.em.createQuery(cd).executeUpdate();
    }

    public void close() {
    }
}

