/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.crash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cli.OptionPrint;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.version.Version;

public class ReportLog
implements Iterable<String> {
    private final List<String> strings = new ArrayList<String>();

    public void add(String s) {
        this.strings.add(s);
    }

    public void addAll(Collection<String> list) {
        for (String s : list) {
            this.add(s);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableList(this.strings).iterator();
    }

    public List<String> asList() {
        return Collections.unmodifiableList(this.strings);
    }

    public void youShouldSendThisDiagram() {
        this.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        this.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        this.add("You can try to turn around this issue by simplifing your diagram.");
    }

    public void checkOldVersionWarning() {
        this.checkOldVersionWarning("<b>");
    }

    public void checkOldVersionWarningRaw() {
        this.checkOldVersionWarning("");
    }

    public void checkOldVersionWarning(String lineFormating) {
        if (Version.versionString().contains("beta")) {
            return;
        }
        long days = (System.currentTimeMillis() - Version.compileTime()) / 1000L / 3600L / 24L;
        if (days >= 140L) {
            this.addEmptyLine();
            this.add(lineFormating + "This version of PlantUML is " + days + " days old, so you should");
            this.add(lineFormating + "consider upgrading from https://plantuml.com/download");
        }
    }

    public void addEmptyLine() {
        this.add(" ");
    }

    public void anErrorHasOccured(Throwable exception, String fullDiagramText) {
        if (exception == null) {
            this.add("An error has occured!");
        } else {
            this.add("An error has occured : " + exception);
        }
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        this.add("<i>" + quote);
        this.addEmptyLine();
        this.add("PlantUML (" + Version.versionString() + ") has crashed.");
        this.addEmptyLine();
        this.checkOldVersionWarning();
        this.add("Diagram size: " + this.lines(fullDiagramText) + " lines / " + fullDiagramText.length() + " characters.");
        this.addEmptyLine();
    }

    private int lines(String text) {
        int result = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    public void pleaseCheckYourGraphVizVersion() {
        this.addEmptyLine();
        this.add("Please go to https://plantuml.com/graphviz-dot to check your GraphViz version.");
        this.addEmptyLine();
    }

    public void thisMayBeCaused() {
        this.add("This may be caused by :");
        this.add(" - a bug in PlantUML");
        this.add(" - a problem in GraphViz");
    }

    public void addDecodeHint() {
        this.addEmptyLine();
        this.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the qrcode)");
    }

    public void addProperties() {
        this.addAll(OptionPrint.interestingProperties());
        this.addAll(OptionPrint.interestingValues());
    }
}

