/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.SafeUtils;

final class LZ4SafeUtils
extends Enum<LZ4SafeUtils> {
    private static final /* synthetic */ LZ4SafeUtils[] $VALUES;

    public static LZ4SafeUtils[] values() {
        return (LZ4SafeUtils[])$VALUES.clone();
    }

    public static LZ4SafeUtils valueOf(String string) {
        return Enum.valueOf(LZ4SafeUtils.class, string);
    }

    static int hash(byte[] byArray, int n2) {
        return LZ4Utils.hash(SafeUtils.readInt(byArray, n2));
    }

    static int hash64k(byte[] byArray, int n2) {
        return LZ4Utils.hash64k(SafeUtils.readInt(byArray, n2));
    }

    static boolean readIntEquals(byte[] byArray, int n2, int n3) {
        return byArray[n2] == byArray[n3] && byArray[n2 + 1] == byArray[n3 + 1] && byArray[n2 + 2] == byArray[n3 + 2] && byArray[n2 + 3] == byArray[n3 + 3];
    }

    static void safeIncrementalCopy(byte[] byArray, int n2, int n3, int n4) {
        for (int i10 = 0; i10 < n4; ++i10) {
            byArray[n3 + i10] = byArray[n2 + i10];
        }
    }

    static void wildIncrementalCopy(byte[] byArray, int n2, int n3, int n4) {
        do {
            LZ4SafeUtils.copy8Bytes(byArray, n2, byArray, n3);
            n2 += 8;
        } while ((n3 += 8) < n4);
    }

    static void copy8Bytes(byte[] byArray, int n2, byte[] byArray2, int n3) {
        for (int i10 = 0; i10 < 8; ++i10) {
            byArray2[n3 + i10] = byArray[n2 + i10];
        }
    }

    static int commonBytes(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 < n4 && byArray[n2++] == byArray[n3++]) {
            ++n5;
        }
        return n5;
    }

    static int commonBytesBackward(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n2 > n4 && n3 > n5 && byArray[--n2] == byArray[--n3]) {
            ++n6;
        }
        return n6;
    }

    static void safeArraycopy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray, n2, byArray2, n3, n4);
    }

    static void wildArraycopy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        try {
            for (int i10 = 0; i10 < n4; i10 += 8) {
                LZ4SafeUtils.copy8Bytes(byArray, n2 + i10, byArray2, n3 + i10);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new LZ4Exception("Malformed input at offset " + n2);
        }
    }

    static int encodeSequence(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8;
        int n9 = n3 - n2;
        int n10 = n6++;
        if (n6 + n9 + 8 + (n9 >>> 8) > n7) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (n9 >= 15) {
            n8 = -16;
            n6 = LZ4SafeUtils.writeLen(n9 - 15, byArray2, n6);
        } else {
            n8 = n9 << 4;
        }
        LZ4SafeUtils.wildArraycopy(byArray, n2, byArray2, n6, n9);
        n6 += n9;
        int n11 = n3 - n4;
        byArray2[n6++] = (byte)n11;
        byArray2[n6++] = (byte)(n11 >>> 8);
        if (n6 + 6 + ((n5 -= 4) >>> 8) > n7) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (n5 >= 15) {
            n8 |= 0xF;
            n6 = LZ4SafeUtils.writeLen(n5 - 15, byArray2, n6);
        } else {
            n8 |= n5;
        }
        byArray2[n10] = (byte)n8;
        return n6;
    }

    static int lastLiterals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n3;
        if (n4 + n6 + 1 + (n6 + 255 - 15) / 255 > n5) {
            throw new LZ4Exception();
        }
        if (n6 >= 15) {
            byArray2[n4++] = -16;
            n4 = LZ4SafeUtils.writeLen(n6 - 15, byArray2, n4);
        } else {
            byArray2[n4++] = (byte)(n6 << 4);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n6);
        return n4 += n6;
    }

    static int writeLen(int n2, byte[] byArray, int n3) {
        while (n2 >= 255) {
            byArray[n3++] = -1;
            n2 -= 255;
        }
        byArray[n3++] = (byte)n2;
        return n3;
    }

    static void copyTo(Match match, Match match2) {
        match2.len = match.len;
        match2.start = match.start;
        match2.ref = match.ref;
    }

    private static /* synthetic */ LZ4SafeUtils[] $values() {
        return new LZ4SafeUtils[0];
    }

    static {
        $VALUES = LZ4SafeUtils.$values();
    }

    static class Match {
        int start;
        int ref;
        int len;

        Match() {
        }

        void fix(int n2) {
            this.start += n2;
            this.ref += n2;
            this.len -= n2;
        }

        int end() {
            return this.start + this.len;
        }
    }
}

