/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbTransaction;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.TransmitAction;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public class V10Transaction
extends AbstractFbTransaction
implements FbWireTransaction {
    private static final System.Logger log = System.getLogger(V10Transaction.class.getName());
    private final int handle;

    public V10Transaction(FbWireDatabase database, int transactionHandle, TransactionState initialState) {
        super(initialState, database);
        this.handle = transactionHandle;
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    protected final void withTransmitLock(TransmitAction transmitAction) throws IOException, SQLException {
        this.getXdrStreamAccess().withTransmitLock(transmitAction);
    }

    private XdrStreamAccess getXdrStreamAccess() {
        return this.getDatabase().getXdrStreamAccess();
    }

    @Override
    protected FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    @Override
    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.COMMITTING);
            this.finishTransaction(30);
            this.switchState(TransactionState.COMMITTED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.COMMITTED, log);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.ROLLING_BACK);
            this.finishTransaction(31);
            this.switchState(TransactionState.ROLLED_BACK);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.ROLLED_BACK, log);
        }
    }

    private void finishTransaction(int commitOrRollback) throws SQLException {
        assert (commitOrRollback == 30 || commitOrRollback == 31) : "Unsupported operation code " + commitOrRollback;
        try {
            this.withTransmitLock(xdrOut -> {
                xdrOut.writeInt(commitOrRollback);
                xdrOut.writeInt(this.handle);
                xdrOut.flush();
            });
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
        try {
            this.getDatabase().readResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public void prepare(byte[] recoveryInformation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.PREPARING);
            this.sendPrepare(recoveryInformation);
            this.receivePrepareResponse();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.PREPARED, log);
        }
    }

    private void sendPrepare(byte[] recoveryInformation) throws SQLException {
        try {
            this.withTransmitLock(xdrOut -> {
                if (recoveryInformation != null) {
                    xdrOut.writeInt(51);
                    xdrOut.writeInt(this.handle);
                    xdrOut.writeBuffer(recoveryInformation);
                } else {
                    xdrOut.writeInt(32);
                    xdrOut.writeInt(this.handle);
                }
                xdrOut.flush();
            });
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receivePrepareResponse() throws SQLException {
        try {
            this.getDatabase().readResponse(null);
            this.switchState(TransactionState.PREPARED);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public byte[] getTransactionInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            return this.getDatabase().getInfo(42, this.getHandle(), requestItems, maxBufferLength, null);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

